package row_data_gateway;
import db_context.DbContext;
import db_context.MyExceptions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PackageFinder {
    private static final PackageFinder INSTANCE = new PackageFinder();

    public static PackageFinder getInstance() {
        return INSTANCE;
    }

    private PackageFinder() {
    }

    public Package findById(int id) throws SQLException, MyExceptions.NotSuchIdException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM packages WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Package p = new Package();
                    p.setId(r.getInt("id"));
                    p.setInsurance(r.getString("insurance"));
                    p.setStatus(r.getString("status"));
                    p.setDelivery_attempts(r.getInt("delivery_attempts"));
                    p.setDamage(r.getInt("damage"));
                    p.setSender_id(r.getInt("sender_id"));
                    p.setRecipient_id(r.getInt("recipient_id"));
                    if (r.next()) {
                        throw new RuntimeException("Move than one row was returned");
                    }
                    return p;
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such package");
                }
            }

        }
    }
}
